local Convo = require "questral.convo"
local Npc = require "components.npc"
local Quest = require "questral.quest"
local Quip = require "questral.quip"
local rotwoodquestutil = require "questral.game.rotwoodquestutil"
local quest_strings = require("strings.strings_npc_armorsmith").QUESTS.ingot_explainer

------QUEST SETUP------

local Q = Quest.CreateJob()

-- ------CONVERSATIONS AND QUESTS------

local convo = function(cx)
	cx:CompleteQuest()
	cx:Question("1")
		:Fn(function()
			cx:Question("2A")
			cx:Question("2B")
			cx:JoinAllOpt_Fn(function()
				cx:Question("3B")
					:Fn(function()
						local clicked_any = false
						local clicked_4A = false
						local clicked_4B = false
						local clicked_4C = false
						local question_4A = "QUESTION_4A"
						local question_4B = "QUESTION_4B"
						cx:Loop(function()
							if clicked_any then
								question_4A = "QUESTION_4A_ALT"
								question_4B = "QUESTION_4B_ALT"
							end

							if not clicked_4A then
								cx:Opt(question_4A) 
									:Fn(function()
										cx:Talk("ANSWER_4A")
										clicked_any = true
										clicked_4A = true
									end)
							end
							if not clicked_4B then
								cx:Opt(question_4B) 
									:Fn(function()
										cx:Talk("ANSWER_4B")
										clicked_any = true
										clicked_4B = true
									end)
							end
							if not clicked_4C then
								cx:Opt("QUESTION_4C")
									:Fn(function()
										cx:Talk("ANSWER_4C")
										clicked_any = true
										clicked_4C = true
									end)
							end	
							cx:AddEnd("QUESTION_4D")
								:Fn(function() 
									cx:Talk("ANSWER_4D")
								end)
								:EndLoop()
						end)
					end)
				cx:AddEnd("QUESTION_3C")
					:Fn(function() 
						cx:Talk("ANSWER_4D")
					end)
			end)
		end)	
end

local quip_convo = 
{
	tags = { "chitchat", "role_armorsmith", "in_town", "holding_any_ingot" },
	tag_scores = 
	{
		holding_any_ingot = 90
	},
	strings = quest_strings,
	quip = quest_strings.TALK,
	important = true,
	convo = convo,
	prefab = "npc_armorsmith"
}

rotwoodquestutil.AddQuipConvo(Q, quip_convo)

return Q
